/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.i18n;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.util.i18n.PropertiesFsResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class FsControl
extends ResourceBundle.Control {
    private final File baseDir;

    public FsControl(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public List<String> getFormats(String baseName) {
        return Collections.singletonList("fs.properties");
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        if (bundle instanceof PropertiesFsResourceBundle) {
            PropertiesFsResourceBundle fsBundle = (PropertiesFsResourceBundle)bundle;
            if (this != fsBundle.getFsControl()) {
                return true;
            }
            long fileTime = fsBundle.getPropertyFile().lastModified();
            return loadTime < fileTime;
        }
        return true;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        Preconditions.checkState("fs.properties".equals(format));
        PropertiesFsResourceBundle bundle = null;
        String name = this.toBundleName(baseName, locale);
        File bundleFile = new File(this.baseDir, name + ".properties");
        if (bundleFile.exists()) {
            bundle = new PropertiesFsResourceBundle(bundleFile, this);
        }
        return bundle;
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        return 0L;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("baseDir", this.baseDir).toString();
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        return null;
    }
}

